﻿using System;
using VA.TMP.Integration.VIMT.Messages.Vista;
using VA.TMP.Integration.VIMT.Vista.Links;
using VA.TMP.Integration.VIMT.Vista.Mappers;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.GroupCancelAppointment
{
    public class CreateResponseStep:FilterBase<CancelGroupAppointmentStateObject>
    {
        public override void Execute(CancelGroupAppointmentStateObject state)
        {
            if (!string.IsNullOrEmpty(state.CancelAppointmentFakeResponseType))
            {
                state.CancelGroupAppointmentResponse = new CancelGroupAppointmentResponseMessage
                {
                    ExceptionMessage = "*****THIS IS FAKE DATA. DATA NOT SENT TO VVS*****",
                    ExceptionOccured = false,
                    SerializedInstance = state.SerializedCancelRequest,
                    PatVistaAppointment = VistaSchedulingUtilities.MapCancelAppointmentEcToLob(Side.Patient, state.PatEcResponse, state.PatEcRequest, state.ServiceAppointment.Id, state.CrmAppointment.Id, state.PatientFacility, state.PatientClinic),
                    ProVistaAppointment = VistaSchedulingUtilities.MapCancelAppointmentEcToLob(Side.Provider, state.ProEcResponse, state.ProEcRequest, state.ServiceAppointment.Id, state.CrmAppointment.Id, state.ProviderFacility, state.ProviderClinic)
                };
            }
            else
            {
                state.CancelGroupAppointmentResponse = state.ExceptionOccured ?
                    new CancelGroupAppointmentResponseMessage
                    {
                        ExceptionOccured = true,
                        ExceptionMessage = state.ExceptionMessage,
                        SerializedInstance = state.SerializedCancelRequest,
                        EcProcessingMs = state.EcProcessingTimeMs
                    } : new CancelGroupAppointmentResponseMessage
                    {
                        ExceptionMessage = string.Empty,
                        ExceptionOccured = false,
                        SerializedInstance = state.SerializedCancelRequest,
                        PatVistaAppointment = VistaSchedulingUtilities.MapCancelAppointmentEcToLob(Side.Patient, state.PatEcResponse, state.PatEcRequest, state.ServiceAppointment.Id, state.CrmAppointment.Id, state.PatientFacility, state.PatientClinic),
                        ProVistaAppointment = VistaSchedulingUtilities.MapCancelAppointmentEcToLob(Side.Provider, state.ProEcResponse, state.ProEcRequest, state.ServiceAppointment.Id, state.CrmAppointment.Id, state.ProviderFacility, state.ProviderClinic),
                        EcProcessingMs = state.EcProcessingTimeMs
                    };
            }
        }
    }
}
